/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#if MX_OS_WINNT
#include "getopt.h"
#else
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__driver_interface.h"
#include "mx__fops.h"

void 
usage()
{
  fprintf(stderr, "Usage: mx_hostname [args]\n");
  fprintf(stderr, "-b - Board number [0]\n");
  fprintf(stderr, "-c - Clear all peer names [0]\n");
  fprintf(stderr, "-n HOSTNAME - Set the MX hostname to HOSTNAME\n");
  fprintf(stderr, "-h - help\n");
}

int 
main(int argc, char **argv)
{
  mx_endpt_handle_t fd;
  int c, board_number, clear, ret;
  char *hostname;
  mx_set_hostname_t h;

  board_number = 0;
  clear = 0;
  hostname = 0;

  while ((c = getopt(argc, argv, "hcb:n:")) != EOF) switch(c) {
  case 'b':
    board_number = atoi(optarg);
    break;
  case 'c':
    clear = 1;
    break;
  case 'n':
    hostname = optarg;
    break;
  case 'h':
  default:
    usage();
    exit(1);
  }

  if (!hostname && !clear) {
    usage();
    fprintf(stderr, "At least one of -h or -c must be supplied\n");
    exit(2);
  }

  mx_init();
  mx_set_error_handler(MX_ERRORS_RETURN);
  ret = mx_open_any_board(&fd);
  if (ret != MX_SUCCESS) {
    printf("open failed: %s\n", mx_strerror(ret));
    return 0;
  }
  if (hostname) {
    h.len = strlen(hostname) + 1;  /* need to account for null */
    h.va = (uint64_t)(uintptr_t)hostname;
    h.board_number = board_number;
    ret = mx__set_host_name(fd, &h);
    if (ret) {
      perror("mx__set_hostname failed");
      exit(1);
    }
  }
  if (clear) {
    ret = mx__clear_peer_names(fd);
    if (ret) {
      perror("mx__clear_peer_names failed");
      exit(1);
    }
  }
  return 0;
}
